---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：2-turbo run build バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **リモートキャッシュの動作詳細**：根拠不足
  2. **パッケージ数の見積もり**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `turbo.json` - Turborepoタスク定義
- E-02: `package.json` (ルート) - scripts.build 定義
- E-03: `package.json` (ルート) - workspaces 定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | buildタスクはdependsOn: ["^build"]で依存解決 | E-01 | ○ |
| C-02 | outputs: ["dist/**"]でキャッシュ対象指定 | E-01 | ○ |
| C-03 | daemonモードは無効 | E-01 ("daemon": false) | ○ |
| C-04 | globalEnvにNEXT_CI_RUNNER | E-01 | ○ |
| C-05 | 実行コマンドにremote-cache-timeout 60 | E-02 | ○ |
| C-06 | --summarize trueオプション | E-02 | ○ |
| C-07 | pnpmワークスペースでpackages/*を管理 | E-03 | ○ |
| C-08 | UIモードはtui | E-01 ("ui": "tui") | ○ |
| C-09 | TypeScriptタスクの定義 | E-01 | ○ |
| C-10 | get-test-timingsタスクの定義 | E-01 | ○ |
| C-11 | リモートキャッシュの詳細な動作仕様 | **根拠なし** | △ |
| C-12 | パッケージ数が約10-15 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リモートキャッシュの設定と動作はTurborepoのドキュメントに依存する。turbo.jsonにはリモートキャッシュの明示的設定がない。
  - 候補：Turborepo公式ドキュメント / .turbo/config.json / Vercelプロジェクト設定
- パッケージ数はpackages/ディレクトリの実際の内容を確認する必要がある
  - 候補：`ls packages/` の実行結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - turbo.jsonの設定内容は直接確認済み
- 0: 低リスク - package.jsonのscripts.build定義は直接確認済み
- 1: 中リスク - リモートキャッシュの動作はTurborepoの外部仕様に依存

## 6) レビュアーチェックリスト（最小）
- [ ] turbo.jsonのタスク定義が最新であるか確認
- [ ] リモートキャッシュの設定・認証方法が正しいか確認
- [ ] 実際のパッケージ数と記述が一致するか確認
